function plotSQxyz(Qx,Qy,Qz,intentsity)
% plotSQxyz(Qx,Qy,Qz,intentsity)
% plotter for SQxyz simulations generated using mint.

if numel(Qx) == 1
    [Y,Z] = meshgrid(Qy,Qz);
    X = ones(size(intentsity)).*Qx;
elseif numel(Qy) == 1
    [X,Z] = meshgrid(Qx,Qz);
    Y = ones(size(intentsity)).*Qy;
elseif numel(Qz) == 1
    [X,Y] = meshgrid(Qx,Qy);
    Z = ones(size(intentsity)).*Qz;
else
    error('one dimention in Q must be a single value')
end

surf(X,Y,Z,intentsity);
xlabel('Qy ($\AA^{-1}$)','interpreter','latex')
ylabel('Qx ($\AA^{-1}$)','interpreter','latex')
zlabel('Qz ($\AA^{-1}$)','interpreter','latex')
shading interp; colorbar;


