% MINT - Simulate the inelastic neutron scattering of magnetic ions and molecules.
%
% [cross_sect,Eigs,Vecs] = mint(Sys,Exp,Opt)
% cross_sect = mint(Sys,Exp)
%
% Standard <a href="matlab: 
% web('https://easyspin.org/')">easyspin</a> (Sys, Exp, Opt) type input structures are required
% with neutron scattering specific fields:
%
% Exp
%-----
% Exp.SpectrumType, this can be either:
% 'SE'   (energy spectrum with integrated Q for powder samples).
% 'SQ'   (Q dependence with integrated energy for powder samples).
% 'SQE'  (2D energy versus Q spectrum for powder samples).
% 'SQxyz' (3D Q dependence in x, y z directions for single crystal samples).
% 'SExyz' (energy spectrum with integrated Q for single crystal samples).
%
% Exp.Energy is an array, the INS energy range in meV (for SE, SQE).
%
% Exp.lwfwhm is gaussian broadening FWHM of INS peaks in meV (for SE, SQE, SExyz).
%
% Exp.Q is an array, the INS momentum transfer in A^-1 (for SQ, SE, SQE).
%
% Exp.Qx, Exp.Qy, Exp.Qz are arrays for INS momentum transfer in A^-1 (for SQxyz, SExyz). 
%
% Exp.InitialStates is an array, initial states included in the calculation.
% Exp.FinalStates is an array, final states included in the calculation.
% If InitialStates or FinalStates are not given they are calulated based on 
% Exp.Temperature and the Exp.Energy range provided.
%
% Exp.B is an applied external magnetic field in with direction x, y, z in mT.
% Applied fields can only be included for single crystal experiments.
%
% Sys
%-----
% Sys.FormFactor is the magnetic formfactor, given by the element symbol
% followed by a number representing the oxidation state for heterometallic 
% compounds a cell array is given, i.e. Sys.FormFactor = {'Tb3','Cu2'}
% Transition metal and lanthanide ions included for typical oxidation
% Magnetic form factors are given in the spin-only approximation, suitable for orbital quenched ions
% and non-orbital quenched ions at low neutron momentum transfers
% states. If the required element / oxidation state is not available, give a 1x15 array
% for <jo>, <j2> and gJ as [j0A j0a j0B j0b j0C j0c j0D j2A j2a j2B j2b j2C j2c j2D gJ].
%
% Sys.Coords = [site1x site1y site1z ; site2x site2y site2z; etc];
% to simulate the INS of a metal ion cluster you need to know relative the
% atomic cartesian coordinates of each metal sites in Angstroms.
% The atomic coordinates are in the same reference frame as the spin system.
% (Note - that Sys.J is +J S1S2)
%
% Opt
%-----
% Opt.NumEigs is an integer that caps the number of eigenvalues considered 
% in the INS simulation, suitable when only the lowest eigenvalues are accessed 
% experimentally. This is relevant when computing large spin systems with 
% Hamiltonian matrix dimensions that are prohibitively large to evaluate in
% their entirety. 
% 
% Dr Michael L. Baker
% Department of Chemistry, The University of Manchester, UK.
% michael.baker@manchester.ac.uk
% For more information, see the <a href="matlab: 
% web('https://www.mlbakerlab.co.uk')"> M. L. Baker lab web site</a>.
% 